package ru.yandex.market.clickphite.config.metric;

import ru.yandex.market.clickphite.metric.MetricStorage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 18.07.2018
 */
public class SolomonSensorConfig extends AbstractMetricConfig<SolomonSensorConfig> {
    private Map<String, String> labels;
    private String metricField;
    private List<MetricSplit> splits;
    private MetricType type = MetricType.SIMPLE;
    private List<String> quantiles = Arrays.asList(
        "0.5", "0.6", "0.7", "0.80", "0.90", "0.95", "0.97", "0.99", "0.995", "0.997", "0.999", "1"
    );

    public SolomonSensorConfig() {
    }

    private SolomonSensorConfig(SolomonSensorConfig other) {
        super(other);
        this.labels = other.labels;
        this.metricField = other.metricField;
        this.splits = other.splits;
        this.type = other.type;
        this.quantiles = other.quantiles;
    }

    @Override
    public SolomonSensorConfig copy() {
        return new SolomonSensorConfig(this);
    }

    @Override
    public List<? extends MetricField> getFields() {
        return Collections.singletonList(
            new MetricField() {
                @Override
                public String getName() {
                    return "value";
                }

                @Override
                public String getField() {
                    return metricField;
                }

                @Override
                public MetricType getType() {
                    return type;
                }

                @Override
                public List<String> getQuantiles() {
                    return SolomonSensorConfig.this.getQuantiles();
                }
            }
        );
    }

    @Override
    public List<MetricSplit> getSplits() {
        return splits;
    }

    @Override
    public MetricStorage getStorage() {
        return MetricStorage.SOLOMON;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public String getMetricField() {
        return metricField;
    }

    public void setMetricField(String metricField) {
        this.metricField = metricField;
    }

    public void setSplits(List<MetricSplit> splits) {
        this.splits = splits;
    }

    @Override
    public MetricType getType() {
        return type;
    }

    public void setType(MetricType type) {
        this.type = type;
    }

    @Override
    public List<String> getQuantiles() {
        return type.isQuantile() ? quantiles : Collections.emptyList();
    }
}
