package ru.yandex.market.clickphite.config.metric;

import java.util.Arrays;

/**
 * Конфиг для вычисления аггрегатной функции в подзапросе.
 */
public class SubAggregateConfig {
    private String[] keys;
    private SubAggregateExpression[] aggregateExpressions;

    public SubAggregateConfig() {
    }

    public SubAggregateConfig(String[] keys, SubAggregateExpression[] aggregateExpression) {
        this.keys = keys;
        this.aggregateExpressions = aggregateExpression;
    }

    public String[] getKeys() {
        return keys;
    }

    public SubAggregateExpression[] getAggregateExpressions() {
        return aggregateExpressions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SubAggregateConfig that = (SubAggregateConfig) o;

        return Arrays.equals(keys, that.keys)
                && Arrays.equals(aggregateExpressions, that.aggregateExpressions);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(keys);
        result = 31 * result + Arrays.hashCode(aggregateExpressions);
        return result;
    }
}
