package ru.yandex.market.clickphite.config.monitoring;

import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 19/01/16
 */
public class MonitoringConfig {

    private String name;
    private String title;
    private String metric;

    private String quantile;

    private RangeConfig range;
    private KronosConfig kronos;
    private RazladkiConfig razladki;

    private int warnsToCrit = -1;
    private int checkPoints = 10;
    private int monitoringDelayMinutes = 0;

    public MonitoringConfig(String name, String title, String metric) {
        this.name = name;
        this.title = title;
        this.metric = metric;
    }

    public MonitoringConfig() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setQuantile(String quantile) {
        this.quantile = quantile;
    }

    public void setWarnsToCrit(int warnsToCrit) {
        this.warnsToCrit = warnsToCrit;
    }

    public void setCheckPoints(int checkPoints) {
        this.checkPoints = checkPoints;
    }

    public void setMonitoringDelayMinutes(int monitoringDelayMinutes) {
        this.monitoringDelayMinutes = monitoringDelayMinutes;
    }

    public int getMonitoringDelayMinutes() {
        return monitoringDelayMinutes;
    }


    public int getMonitoringDelaySeconds() {
        return (int) TimeUnit.MINUTES.toSeconds(monitoringDelayMinutes);
    }

    public String getName() {
        return name;
    }

    public String getTitle() {
        return title;
    }

    public String getMetric() {
        return metric;
    }

    public int getWarnsToCrit() {
        return warnsToCrit;
    }

    public int getCheckPoints() {
        return checkPoints;
    }

    public RangeConfig getRange() {
        return range;
    }

    public void setRange(RangeConfig range) {
        this.range = range;
    }

    public KronosConfig getKronos() {
        return kronos;
    }

    public void setKronos(KronosConfig kronos) {
        this.kronos = kronos;
    }

    public RazladkiConfig getRazladki() {
        return razladki;
    }

    public void setRazladki(RazladkiConfig razladki) {
        this.razladki = razladki;
    }

    public String getQuantile() {
        return quantile;
    }

    @Override
    public String toString() {
        return "MonitoringConfig{" +
            "name='" + name + '\'' +
            ", title='" + title + '\'' +
            ", metric='" + metric + '\'' +
            ", quantile=" + quantile +
            '}';
    }
}
