package ru.yandex.market.clickphite.dashboard;

import java.util.Arrays;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 15/05/15
 */
public class DashboardMetric {
    private final String[] metrics;

    public DashboardMetric(String... metrics) {
        this.metrics = metrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DashboardMetric that = (DashboardMetric) o;
        return Arrays.equals(metrics, that.metrics);
    }

    public String getSplit(int index) {
        return metrics[index];
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(metrics);
    }
}
