package ru.yandex.market.clickphite.dictionary;

import com.google.common.base.Preconditions;
import ru.yandex.market.clickhouse.ddl.Column;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public interface Dictionary {

    String DATABASE = "dict";
    TableEngine ENGINE = TableEngine.TINY_LOG;

    default String getDb() {
        return DATABASE;
    }

    String getTable();

    List<Column> getColumns();

    default List<Column> getCalculatedColumns() {
        return new ArrayList<>();
    }

    default List<Column> getAllColumns() {
        List<Column> columnsWithUndifinedDefaultExpression = getCalculatedColumns()
                .stream()
                .filter(c -> Objects.isNull(c.getDefaultExpr()))
                .collect(Collectors.toList());
        Preconditions.checkArgument(columnsWithUndifinedDefaultExpression.isEmpty(),
                "All of CalculatedColumns must have DefaultExpr, columnst to fix: %s",
                columnsWithUndifinedDefaultExpression
        );

        return Stream.concat(getColumns().stream(), getCalculatedColumns().stream()).collect(Collectors.toList());
    }

    default TableEngine getEngine() {
        return ENGINE;
    }

    default String getEngineSpec() {
        return "";
    }
}
