package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by solanj on 28.02.18.
 */
public class CategoriesAndParameters implements MergeTreeDictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("category_id", ColumnType.Int64, "-1"),
        new Column("parent", ColumnType.Int64, "-1"),
        new Column("category_name", ColumnType.String, "''"),
        new Column("category_uniq_name", ColumnType.String, "''"),
        new Column("category_description", ColumnType.String, "''"),
        new Column("output_type", ColumnType.String, "''"),
        new Column("market_view", ColumnType.String, "''"),
        new Column("visual", ColumnType.UInt8, "0"),
        new Column("visual_show_with_childs", ColumnType.UInt8, "0"),
        new Column("output_category_id", ColumnType.Int64, "-1"),
        new Column("model_list_id", ColumnType.Int64, "-1"),
        new Column("position", ColumnType.Int64, "-1"),
        new Column("special", ColumnType.Int64, "-1"),
        new Column("related_categories", ColumnType.ArrayInt64, "emptyArrayInt64()", "[]"),
        new Column("param_id", ColumnType.Int64, "-1"),
        new Column("param_type", ColumnType.String, "''"),
        new Column("param_name", ColumnType.String, "''"),
        new Column("param_xslname", ColumnType.String, "''"),
        new Column("use_for_gurulight", ColumnType.UInt8, "0"),
        new Column("importance", ColumnType.Float32, "0.0"),
        new Column("parameter_description", ColumnType.String, "''"),
        new Column("value_type", ColumnType.String, "''"),
        new Column("cluster_breaker", ColumnType.UInt8, "0")
    );


    @Override
    public String getTable() {
        return "categories_and_parameters";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public Column getDateColumn() {
        return FAKE_DATE_COLUMN;
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Collections.singletonList(
            new Column("param_name", ColumnType.Int64)
        );
    }
}
