package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class CategoriesDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.UInt64, "0"),
        new Column("parent_id", ColumnType.UInt64, "0"),
        new Column("hyper_id", ColumnType.UInt64, "0"),
        new Column("parent_hyper_id", ColumnType.UInt64, "0"),
        new Column("name", ColumnType.String, "''"),
        new Column("not_used", ColumnType.UInt8, "0"),
        new Column("no_search", ColumnType.UInt8, "0"),
        new Column("children", ColumnType.ArrayUInt64, "emptyArrayUInt64()", "[]"),
        new Column("parents", ColumnType.ArrayUInt64, "emptyArrayUInt64()", "[]"),
        new Column("parent_hyper_ids", ColumnType.ArrayUInt64, "emptyArrayUInt64()", "[]"),
        new Column("parents_names", ColumnType.ArrayString, "emptyArrayString()", "[]"),
        new Column("en_name", ColumnType.String, "''"),
        new Column("parents_en_names", ColumnType.ArrayString, "emptyArrayString()", "[]")
    );

    @Override
    public String getTable() {
        return "categories";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
