package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class CategoryDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("category_id", ColumnType.UInt64),
        new Column("parent_id", ColumnType.UInt64),
        new Column("name", ColumnType.String),
        new Column("full_name", ColumnType.String),
        new Column("leaf", ColumnType.Int8),
        new Column("published", ColumnType.Int8)
    );

    @Override
    public String getTable() {
        return "category";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
