package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * Created by entarrion <entarrion@yandex-team.ru> on 18.05.17.
 */
public class ConversionRatesDictionary implements Dictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("hid", ColumnType.Int64),
        new Column("name", ColumnType.String),
        new Column("category_id", ColumnType.Int64),
        new Column("is_moscow", ColumnType.UInt8),
        new Column("cpa", ColumnType.UInt8),
        new Column("actr_a", ColumnType.Float64),
        new Column("actr_b", ColumnType.Float64),
        new Column("aconv_a", ColumnType.Float64),
        new Column("aconv_b", ColumnType.Float64)
    );

    @Override
    public String getTable() {
        return "conversion_rates";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
