package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.YtSource;

import java.util.Arrays;
import java.util.List;

@YtSource("//home/market/production/mstat/analyst/regular/costs_and_sales/currency_coefficients/latest")
public class CurrencyCoefficientsDictionary implements Dictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("coefficient", ColumnType.Float32, "1.0"),
        new Column("shop_id", ColumnType.Int32, "0"),
        new Column("sends_valid_data", ColumnType.UInt8, "1"),
        new Column("description", ColumnType.String, "''")
    );

    @Override
    public String getTable() {
        return "currency_coefficients";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
