package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

public class CutoffTypesDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.Int64, DefaultExpr.INT),
        new Column("name", ColumnType.String, DefaultExpr.STRING),
        new Column("shop_program", ColumnType.String, DefaultExpr.STRING)
    );

    @Override
    public String getTable() {
        return "cutoff_types";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
