package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * Created by astepanel on 04.12.17.
 */
public class DeliveryRegionGroups implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("region_group_id", ColumnType.Int64, "0"),
            new Column("shop_id", ColumnType.Int64, "0"),
            new Column("group_name", ColumnType.String, ""),
            new Column("currency", ColumnType.String, ""),
            new Column("is_self_region", ColumnType.Int64, "0"),
            new Column("group_check_status", ColumnType.Int64, "0"),
            new Column("check_status_modified_at", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
            new Column("delivery_tariff_type", ColumnType.Int64, "0"),
            new Column("modified_at", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
            new Column("modified_by", ColumnType.Int64, "0"),
            new Column("notes", ColumnType.String, "")
        );

    @Override
    public String getTable() {
        return "delivery_region_groups";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
