package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * Словарь клидов, загружаемый из Дистрибуции через МСТАТ.
 *
 * @author zoom
 */
public class DistributionClidsDictionary implements Dictionary {

    /**
     * Первичный ключ словаря.
     */
    private static final String ID_COLUMN = "id";

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column(ID_COLUMN, ColumnType.Int64),
            new Column("type_id", ColumnType.UInt64, "0"),
            new Column("set_id", ColumnType.UInt64, "0"),
            new Column("page_id", ColumnType.UInt64, "0"),
            new Column("pack_id", ColumnType.UInt64, "0"),
            new Column("soft_id", ColumnType.UInt64, "0"),
            new Column("is_payable_id", ColumnType.UInt64, "0"),
            new Column("contract_tag_id", ColumnType.UInt64, "0"),
            new Column("tag_caption", ColumnType.String, ""),
            new Column("set_domain", ColumnType.String, ""),
            new Column("set_caption", ColumnType.String, ""),
            new Column("pack_domain", ColumnType.String, ""),
            new Column("pack_caption", ColumnType.String, ""),
            new Column("user_login", ColumnType.String, ""),
            new Column("view_statistics", ColumnType.UInt64, "0")
        );


    @Override
    public String getTable() {
        return "distribution_clids";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
