package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author zoom
 */
public class DistributionRegionGroupsDictionary implements Dictionary {

    /**
     * Первичные ключ словаря.
     */
    private static final String ID_COLUMN = "id";

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column(ID_COLUMN, ColumnType.Int16),
        new Column("name", ColumnType.String),
        new Column("inc_region_ids", ColumnType.ArrayUInt32),
        new Column("exc_region_ids", ColumnType.ArrayUInt32)
    );

    @Override
    public String getTable() {
        return "distribution_region_groups";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
