package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class DomainsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("shop_id", ColumnType.Int64, "-1"),
        new Column("domain", ColumnType.String, "''")
    );

    @Override
    public String getTable() {
        return "domains";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
