package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class HostToDcDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("host", ColumnType.String),
        new Column("dc", ColumnType.String),
        new Column("stage", ColumnType.String)
    );

    private static final List<Column> CALCULATED_COLUMNS = Collections.singletonList(
        new Column("host_id", ColumnType.UInt64, "sipHash64(host)")
    );

    @Override
    public String getTable() {
        return "host2dc";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public List<Column> getCalculatedColumns() {
        return CALCULATED_COLUMNS;
    }
}
