package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by solanj on 26.04.18.
 */
public class IndexerHiddenOffers implements MergeTreeDictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("feed_id", ColumnType.String, "''"),
        new Column("offer_id", ColumnType.String, "''"),
        new Column("url", ColumnType.String, "''"),
        new Column("offer_name", ColumnType.String, "''"),
        new Column("shop_id", ColumnType.Int64, "-1"),
        new Column("category_id", ColumnType.Int64, "-1"),
        new Column("hiding_time", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
        new Column("error_code", ColumnType.String, "''"),
        new Column("error_message", ColumnType.String, "''"),
        new Column("details", ColumnType.String, "''")
    );


    @Override
    public String getTable() {
        return "indexer_hidden_offers";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public Column getDateColumn() {
        return FAKE_DATE_COLUMN;
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Collections.singletonList(
            new Column("feed_id", ColumnType.Int64)
        );
    }
}
