package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class ModelsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.Int64),
        new Column("name", ColumnType.String, "''"),
        new Column("category_id", ColumnType.Int64, "-1"),
        new Column("vendor_id", ColumnType.Int64, "-1"),
        new Column("created_date", ColumnType.Date),
        new Column("is_guru", ColumnType.Int8)
    );

    @Override
    public String getTable() {
        return "models";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
