package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;
import ru.yandex.market.clickphite.dictionary.YtSource;

import java.util.Arrays;
import java.util.List;

/**
 * Created by kateleb on 15.06.17.
 */
@YtSource("//home/market/production/mstat/analyst/dictionaries/analyst_order_dict")
public class OrdersAggrDictionary implements MergeTreeDictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("event_id", ColumnType.Int64, "-1"),
        new Column("offer_ware_md5", ColumnType.String, "''"),
        new Column("offer_feed_id", ColumnType.String, "''"),
        new Column("offer_feed_category_id", ColumnType.String, "''"),
        new Column("offer_availability", ColumnType.String, "''"),
        new Column("offer_price", ColumnType.Float64, "0.0"),
        new Column("offer_currency", ColumnType.String, "''"),
        new Column("offer_fee", ColumnType.Float64, "0.0"),
        new Column("order_fee", ColumnType.Float64, "0.0"),
        new Column("model_id", ColumnType.Int64, "-1"),
        new Column("model_hid", ColumnType.Int64, "-1"),
        new Column("show_block_id", ColumnType.String, "''"),
        new Column("show_uid", ColumnType.String, "''"),
        new Column("item_count", ColumnType.Int32, "0"),
        new Column("item_price", ColumnType.Float64, "0.0"),
        new Column("item_revenue", ColumnType.Float64, "0.0"),
        new Column("buyer_price", ColumnType.Float64, "0.0"),
        new Column("buyer_currency", ColumnType.String, "''"),
        new Column("order_status", ColumnType.String, "''"),
        new Column("order_substatus", ColumnType.String, "''"),
        new Column("order_is_fake", ColumnType.UInt8, "0"),
        new Column("payment_type", ColumnType.String, "''"),
        new Column("payment_method", ColumnType.String, "''"),
        new Column("order_accept_method", ColumnType.String, "''"),
        new Column("buyer_uid", ColumnType.String, "''"),
        new Column("buyer_is_auth", ColumnType.UInt8, "0"),
        new Column("buyer_user_group", ColumnType.String, "''"),
        new Column("buyer_is_fake", ColumnType.UInt8, "0"),
        new Column("buyer_region_id", ColumnType.Int64, "-1"),
        new Column("buyer_uuid", ColumnType.String, "''"),
        new Column("buyer_device_type", ColumnType.String, "''"),
        new Column("buyer_platform", ColumnType.String, "''"),
        new Column("click_rough_pp", ColumnType.String, "''"),
        new Column("delivery_type", ColumnType.String, "''"),
        new Column("delivery_price", ColumnType.Float64, "0.0"),
        new Column("delivery_buyer_price", ColumnType.Float64, "0.0"),
        new Column("delivery_from_date", ColumnType.Date, "'0000-00-00'"),
        new Column("delivery_to_date", ColumnType.Date, "'0000-00-00'"),
        new Column("delivery_region_id", ColumnType.Int64, "-1"),
        new Column("shop_id", ColumnType.Int64, "-1"),
        new Column("shop_is_fake", ColumnType.UInt8, "0"),
        new Column("event_type", ColumnType.String, "''"),
        new Column("event_time", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
        new Column("event_hour", ColumnType.Int32, "0"),
        new Column("event_day", ColumnType.Date, "'0000-00-00'"),
        new Column("creation_time", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
        new Column("creation_hour", ColumnType.Int32, "0"),
        new Column("delivery_deliveryserviceid", ColumnType.String, "''"),
        new Column("delivery_shopaddress", ColumnType.String, "''"),
        new Column("delivery_address", ColumnType.String, "''"),
        new Column("delivery_servicename", ColumnType.String, "''"),
        new Column("delivery_hiddenpaymentoptions", ColumnType.String, "''"),
        new Column("delivery_paymentoptions", ColumnType.String, "''"),
        new Column("delivery_validfeatures", ColumnType.String, "''"),
        new Column("billing_id", ColumnType.Int64, "-1"),
        new Column("billing_time", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
        new Column("billing_hour", ColumnType.Int32, "0"),
        new Column("billing_day", ColumnType.Date, "'0000-00-00'"),
        new Column("order_is_billed", ColumnType.UInt8, "0"),
        new Column("order_statuses", ColumnType.ArrayString, "emptyArrayString()", "[]"),
        new Column("offer_id", ColumnType.String, "''"),
        new Column("order_id", ColumnType.Int64, "-1"),
        new Column("creation_day", ColumnType.Date, "'0000-00-00'"),
        new Column("offer_name", ColumnType.String, "''"),
        new Column("offer_url", ColumnType.String, "''")
    );


    @Override
    public String getTable() {
        return "analyst_orders_dict";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public Column getDateColumn() {
        return new Column("creation_day", ColumnType.Date, "'0000-00-00'");
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Arrays.asList(
                new Column("shop_id", ColumnType.Int64),
                new Column("offer_ware_md5", ColumnType.String)
        );
    }
}
