package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class RegionsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.UInt64, "0"),
        new Column("ru_name", ColumnType.String, "''"),
        new Column("type", ColumnType.Int32, "-1"),
        new Column("parent_id", ColumnType.UInt64, "0"),
        new Column("parent_ru_name", ColumnType.String, "''"),
        new Column("parent_type", ColumnType.Int32, "-1"),
        new Column("country_id", ColumnType.UInt64, "0"),
        new Column("country_ru_name", ColumnType.String, "''"),
        new Column("parents", ColumnType.ArrayUInt64, "emptyArrayUInt64()", "[]"),
        new Column("path_ru_name", ColumnType.ArrayString, "emptyArrayString()", "[]"),
        new Column("children", ColumnType.ArrayUInt64, "emptyArrayUInt64()", "[]"),
        new Column("en_name", ColumnType.String, "''"),
        new Column("parent_en_name", ColumnType.String, "''"),
        new Column("country_en_name", ColumnType.String, "''"),
        new Column("path_en_name", ColumnType.ArrayString, "emptyArrayString()", "[]"),
        new Column("distribution_region_group_id", ColumnType.Int32, "-1")
    );

    @Override
    public String getTable() {
        return "regions";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
