package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class ShopAgencyCampaignsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.Int64, "-1"),
        new Column("name", ColumnType.String, "''"),
        new Column("manager", ColumnType.String, "''"),
        new Column("client_id", ColumnType.Int64, "-1"),
        new Column("campaign_id", ColumnType.Int64, "-1"),
        new Column("datasource_id", ColumnType.Int64, "-1")
    );

    @Override
    public String getTable() {
        return "shop_agency_campaigns";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
