package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class ShopAuditDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("shop_id", ColumnType.Int64, "-1"),
        new Column("url", ColumnType.String, "''"),
        new Column("others", ColumnType.ArrayString, "emptyArrayString()", "[]")
    );

    @Override
    public String getTable() {
        return "shop_audit";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
