package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.YtSource;

import java.util.Arrays;
import java.util.List;

/**
 * Created by entarrion <entarrion@yandex-team.ru> on 25.01.18.
 */
@YtSource("//home/market/production/mstat/dictionaries/shop_category/latest")
public class ShopCategoryDictionary implements Dictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("feed_id", ColumnType.Int32, "0"),
        new Column("category_id", ColumnType.String, "''"),
        new Column("name", ColumnType.String, "''")
    );

    @Override
    public String getTable() {
        return "shop_category";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
