package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class ShopDatasourceDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.Int64, "-1"),
        new Column("name", ColumnType.String, "''"),
        new Column("urlforlog", ColumnType.String, "''"),
        new Column("createdAt", ColumnType.DateTime, "'1970-01-01 00:00:00'"),
        new Column("comments", ColumnType.String, "''"),
        new Column("managerId", ColumnType.Int64, "-1")
    );

    @Override
    public String getTable() {
        return "shop_datasource";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
