package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by solanj on 12.03.18.
 */
public class ShopParamValue implements MergeTreeDictionary {
    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("param_value_id", ColumnType.Int64, "-1"),
        new Column("param_type_id", ColumnType.Int64, "-1"),
        new Column("entity_id", ColumnType.Int64, "-1"),
        new Column("num", ColumnType.Int64, "0"),
        new Column("num_value", ColumnType.Int64, "0"),
        new Column("str_value", ColumnType.String, "''"),
        new Column("date_value", ColumnType.String, "''")
    );


    @Override
    public String getTable() {
        return "shop_param_value";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public Column getDateColumn() {
        return FAKE_DATE_COLUMN;
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Collections.singletonList(
            new Column("entity_id", ColumnType.Int64)
        );
    }
}
