package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Aleksandr Kormushin <kormushin@yandex-team.ru>
 */
public class ShopsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("shop_id", ColumnType.Int64, "-1"),
        new Column("client_id", ColumnType.Int64, "-1"),
        new Column("cpa", ColumnType.String, ""),
        new Column("datasource_name", ColumnType.String, ""),
        new Column("delivery_services", ColumnType.String, ""),
        new Column("delivery_src", ColumnType.String, ""),
        new Column("free", ColumnType.Int8, "-1"),
        new Column("from_market", ColumnType.Int8, "-1"),
        new Column("home_region", ColumnType.Int64, "-1"),
        new Column("is_booknow", ColumnType.Int8, "-1"),
        new Column("is_cpa_partner", ColumnType.Int8, "-1"),
        new Column("is_cpa_prior", ColumnType.Int8, "-1"),
        new Column("is_discounts_enabled", ColumnType.Int8, "-1"),
        new Column("is_enabled", ColumnType.Int8, "-1"),
        new Column("is_global", ColumnType.Int8, "-1"),
        new Column("is_mock", ColumnType.Int8, "-1"),
        new Column("local_delivery_cost", ColumnType.String, "-1"),
        new Column("phone", ColumnType.String, ""),
        new Column("phone_display_options", ColumnType.String, ""),
        new Column("prepay_enabled", ColumnType.Int8, "-1"),
        new Column("priority_region_original", ColumnType.Int64, "-1"),
        new Column("priority_regions", ColumnType.Int64, "-1"),
        new Column("shop_cluster_id", ColumnType.String, "-1"),
        new Column("shop_currency", ColumnType.String, ""),
        new Column("shopname", ColumnType.String, ""),
        new Column("show_premium", ColumnType.Int8, "-1"),
        new Column("tariff", ColumnType.String, ""),
        new Column("is_online", ColumnType.Int8, "-1"),
        new Column("yclid_disabled", ColumnType.Int8, "-1"),
        new Column("regions", ColumnType.ArrayInt64, "emptyArrayInt64()", "[]"),
        new Column("url", ColumnType.String, ""),
        new Column("datafeed_id", ColumnType.Int64, "-1"),
        new Column("return_delivery_address", ColumnType.Int8, "-1"),
        new Column("is_placed", ColumnType.Int8, "-1"),
        new Column("cpc", ColumnType.String, ""),
        new Column("is_cpa20", ColumnType.Int8, "0")
    );

    @Override
    public String getTable() {
        return "shops";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
