package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;

import java.util.Arrays;
import java.util.List;

/**
 * Словарь топовых вендоров по категориям.
 *
 * @author s-ermakov
 */
public class TopVendorsDictionary implements MergeTreeDictionary {

    private static final Column CATEGORY_COLUMN = new Column("category_id", ColumnType.Int64);
    private static final Column VENDOR_COLUMN = new Column("vendor_id", ColumnType.Int64);
    private static final Column FREQUENCY_COLUMN = new Column("frequency", ColumnType.Float32, "-1");

    @Override
    public String getTable() {
        return "topvendors";
    }

    @Override
    public Column getDateColumn() {
        return FAKE_DATE_COLUMN;
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Arrays.asList(CATEGORY_COLUMN, VENDOR_COLUMN);
    }

    @Override
    public List<Column> getColumns() {
        return Arrays.asList(CATEGORY_COLUMN, VENDOR_COLUMN, FREQUENCY_COLUMN);
    }
}
