package ru.yandex.market.clickphite.dictionary.dicts;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.Arrays;
import java.util.List;

/**
 * @author Alexander Gavrikov <agavrikov@yandex-team.ru>
 */
public class VendorsDictionary implements Dictionary {

    private static final List<Column> COLUMNS = Arrays.asList(
        new Column("id", ColumnType.Int64),
        new Column("name", ColumnType.String)
    );

    @Override
    public String getTable() {
        return "vendors";
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
