package ru.yandex.market.clickphite.dictionary.dicts.abo;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class Hypothesis implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("create_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("gen_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hyper_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("offer_id", ColumnType.String, DefaultExpr.STRING),
            new Column("description", ColumnType.String, DefaultExpr.STRING),
            new Column("complain_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("weight", ColumnType.Int64, DefaultExpr.INT),
            new Column("source_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status", ColumnType.Int64, DefaultExpr.INT),
            new Column("must_be_realized", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("failed", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("dup_master_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("old_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("corrector_weight", ColumnType.Int64, DefaultExpr.INT),
            new Column("ware_md5", ColumnType.String, DefaultExpr.STRING),
            new Column("region_id", ColumnType.Int64, DefaultExpr.INT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "hypothesis";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
