package ru.yandex.market.clickphite.dictionary.dicts.abo;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class NoPlacementRecord implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("reason_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("user_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("abo_cutoff_type", ColumnType.String, DefaultExpr.STRING),
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("premod_ticket_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("closed", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "no_placement_record";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
