package ru.yandex.market.clickphite.dictionary.dicts.abo.arbitrage;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class ArbitrageInfo implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("user_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("conversation_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("overdue", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("unread", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "arbitrage_info";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
