package ru.yandex.market.clickphite.dictionary.dicts.abo.arbitrage;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class ArbitrageRefund implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("created_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("updated_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("arbiter_uid", ColumnType.Int64, DefaultExpr.INT),
            new Column("superarbiter_uid", ColumnType.Int64, DefaultExpr.INT),
            new Column("amount", ColumnType.Int64, DefaultExpr.INT),
            new Column("order_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("refund_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("status", ColumnType.Int64, DefaultExpr.INT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "arbitrage_refund";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
