package ru.yandex.market.clickphite.dictionary.dicts.abo.complaint;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class InternalComplaint implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("author_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status", ColumnType.Int64, DefaultExpr.INT),
            new Column("create_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("region_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("session_id", ColumnType.String, DefaultExpr.STRING),
            new Column("offer_removed", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("modification_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("mail_sent", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("cmid", ColumnType.String, DefaultExpr.STRING),
            new Column("ware_md5", ColumnType.String, DefaultExpr.STRING),
            new Column("text", ColumnType.String, DefaultExpr.STRING),
            new Column("external", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("type", ColumnType.Int64, DefaultExpr.INT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "internal_complaint";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
