package ru.yandex.market.clickphite.dictionary.dicts.abo.complaint;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class InternalComplaintOffer implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("complain_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("title", ColumnType.String, DefaultExpr.STRING),
            new Column("hyper_model_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hyper_category_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hyper_category_name", ColumnType.String, DefaultExpr.STRING),
            new Column("price", ColumnType.Float64, DefaultExpr.FLOAT),
            new Column("description", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "internal_complaint_offer";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
