package ru.yandex.market.clickphite.dictionary.dicts.abo.cpa;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class LiteTicket implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("check_method_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("modification_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("user_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("finished", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("mbi_message", ColumnType.String, DefaultExpr.STRING),
            new Column("employee_name", ColumnType.String, DefaultExpr.STRING),
            new Column("phone_num", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "lite_ticket";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
