package ru.yandex.market.clickphite.dictionary.dicts.abo.cpa;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class RecheckTicket implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("shop_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("check_method_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("modification_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("check_item_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("type_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("result_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("ya_uid", ColumnType.String, DefaultExpr.STRING),
            new Column("synopsis", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "recheck_ticket";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
