package ru.yandex.market.clickphite.dictionary.dicts.abo.cpc;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class CoreProblem implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hyp_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("status_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("problem_type_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("creation_tag_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("modification_tag_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("public_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("user_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("modification_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("force_approve", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "core_problem";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
