package ru.yandex.market.clickphite.dictionary.dicts.abo.cpc;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class CoreProblemApprove implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("problem_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("feed_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("feed_session", ColumnType.String, DefaultExpr.STRING),
            new Column("aprv_price", ColumnType.Float64, DefaultExpr.FLOAT),
            new Column("aprv_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("feed_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("raw_feed", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("on_stock", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "core_problem_approve";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
