package ru.yandex.market.clickphite.dictionary.dicts.abo.cpc;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;

import java.util.Arrays;
import java.util.List;

public class CoreProblemType implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("problem_class_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("name", ColumnType.String, DefaultExpr.STRING),
            new Column("description", ColumnType.String, DefaultExpr.STRING),
            new Column("relates_to_placement", ColumnType.String, DefaultExpr.STRING),
            new Column("for_shop_type", ColumnType.Int64, DefaultExpr.INT),
            new Column("sending_message", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("hidden", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("critical", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("can_be_mass", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("waiting_base_update", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("show_in_pi", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("involves_offer_removal", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "core_problem_type";
    }
}
