package ru.yandex.market.clickphite.dictionary.dicts.abo.premod;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.MergeTreeDictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class PremodItem implements MergeTreeDictionary {
    private static final Column CREATION_TIME = new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME);
    private static final Column TYPE_ID = new Column("type_id", ColumnType.Int64, DefaultExpr.INT);
    private static final Column TICKET_ID = new Column("ticket_id", ColumnType.Int64, DefaultExpr.INT);

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            CREATION_TIME,
            new Column("modification_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("status_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("user_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("ya_uid", ColumnType.String, DefaultExpr.STRING),
            TYPE_ID,
            TICKET_ID
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "premod_item";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }

    @Override
    public Column getDateColumn() {
        return FAKE_DATE_COLUMN;
    }

    @Override
    public List<Column> getPrimaryKey() {
        return Arrays.asList(CREATION_TIME, TYPE_ID, TICKET_ID);
    }
}
