package ru.yandex.market.clickphite.dictionary.dicts.abo.premod;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;

import java.util.Arrays;
import java.util.List;

public class PremodItemType implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("name", ColumnType.String, DefaultExpr.STRING),
            new Column("hidden", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("for_offline", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("check_always", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("relates_to_placement", ColumnType.String, DefaultExpr.STRING),
            new Column("critical", ColumnType.Int8, DefaultExpr.INT),
            new Column("order_in_recommendation", ColumnType.Int64, DefaultExpr.INT),
            new Column("position", ColumnType.Int64, DefaultExpr.INT),
            new Column("recommendation_header", ColumnType.String, DefaultExpr.STRING),
            new Column("description", ColumnType.String, DefaultExpr.STRING),
            new Column("group_id", ColumnType.Int64, DefaultExpr.INT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "premod_item_type";
    }
}
