package ru.yandex.market.clickphite.dictionary.dicts.abo.premod;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class PremodProblem implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("item_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("problem_type_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("creation_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("user_comment", ColumnType.String, DefaultExpr.STRING),
            new Column("ya_uid", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "premod_problem";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
