package ru.yandex.market.clickphite.dictionary.dicts.abo.premod;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;

import java.util.Arrays;
import java.util.List;

public class PremodProblemType implements Dictionary {
    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("item_type_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("name", ColumnType.String, DefaultExpr.STRING),
            new Column("type_index", ColumnType.Int64, DefaultExpr.INT),
            new Column("hidden", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("for_offline", ColumnType.UInt8, DefaultExpr.UINT),
            new Column("relates_to_placement", ColumnType.String, DefaultExpr.STRING),
            new Column("recommendation", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "premod_problem_type";
    }
}
