package ru.yandex.market.clickphite.dictionary.dicts.mbi.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class DeliveryOptionGroups implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("region_group_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("delivery_option_group_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("category_order_num", ColumnType.Int64, DefaultExpr.INT),
            new Column("offer_weight_order_num", ColumnType.Int64, DefaultExpr.INT),
            new Column("offer_price_order_num", ColumnType.Int64, DefaultExpr.INT),
            new Column("has_delivery", ColumnType.UInt8, DefaultExpr.UINT)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "shop_delivery_option_groups";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
