package ru.yandex.market.clickphite.dictionary.dicts.mbi.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class DeliveryOptions implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("delivery_option_group_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("days_from", ColumnType.Int64, DefaultExpr.INT),
            new Column("days_to", ColumnType.Int64, DefaultExpr.INT),
            new Column("order_num", ColumnType.Int64, DefaultExpr.INT),
            new Column("order_before_hour", ColumnType.Int64, DefaultExpr.INT),
            new Column("delivery_cost", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "shop_delivery_options";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
