package ru.yandex.market.clickphite.dictionary.dicts.mbi.hidden;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class AboHiddenOffer implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("id", ColumnType.Int64, DefaultExpr.INT),
            new Column("datasource_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("problem_type_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("region_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hiding_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("offer_id", ColumnType.String, DefaultExpr.STRING),
            new Column("offer_name", ColumnType.String, DefaultExpr.STRING),
            new Column("ware_md5", ColumnType.String, DefaultExpr.STRING),
            new Column("category_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("reason", ColumnType.String, DefaultExpr.STRING),
            new Column("subreason", ColumnType.String, DefaultExpr.STRING),
            new Column("url", ColumnType.String, DefaultExpr.STRING),
            new Column("feed_offer_id", ColumnType.String, DefaultExpr.STRING),
            new Column("problem_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("json", ColumnType.String, DefaultExpr.STRING),
            new Column("assessor_comment", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "shop_abo_hidden_offer";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
