package ru.yandex.market.clickphite.dictionary.dicts.mbi.hidden;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.dicts.DefaultExpr;
import ru.yandex.market.clickphite.dictionary.dicts.MarketstatDb;

import java.util.Arrays;
import java.util.List;

public class PapiHiddenOffer implements Dictionary {

    private static final List<Column> COLUMNS =
        Arrays.asList(
            new Column("feed_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("datasource_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("hiding_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("offer_id", ColumnType.String, DefaultExpr.STRING),
            new Column("offer_name", ColumnType.String, DefaultExpr.STRING),
            new Column("url", ColumnType.String, DefaultExpr.STRING),
            new Column("category_id", ColumnType.Int64, DefaultExpr.INT),
            new Column("timeout", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("cmid_update_time", ColumnType.DateTime, DefaultExpr.DATETIME),
            new Column("cmid", ColumnType.String, DefaultExpr.STRING),
            new Column("comment_msg", ColumnType.String, DefaultExpr.STRING),
            new Column("author_client_id", ColumnType.String, DefaultExpr.STRING)
        );

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

    @Override
    public String getTable() {
        return "shop_papi_hidden_offer";
    }

    @Override
    public String getDb() {
        return MarketstatDb.DATABASE_MARKETSTAT;
    }
}
