package ru.yandex.market.clickphite.dictionary.loaders;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.market.clickphite.dictionary.Dictionary;

import java.util.HashMap;
import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @author s-ermakov
 */
public class MboExporterDictionaryLoader extends HttpDictionaryLoader {

    private String mboExporterUrl;
    private Map<String, String> dictionaryToUrlPathMap = new HashMap<>();

    @Override
    public String getDownloadUrl(Dictionary dictionary) {
        String path = dictionaryToUrlPathMap.get(dictionary.getTable());
        checkNotNull(path, "Unknown dictionary %s", dictionary.getTable());
        return mboExporterUrl + path;
    }

    @Required
    public void setMboExporterUrl(String mboExporterUrl) {
        this.mboExporterUrl = mboExporterUrl;
    }

    @Required
    public void setDictionaryToUrlPathMap(Map<String, String> dictionaryToUrlPathMap) {
        this.dictionaryToUrlPathMap = dictionaryToUrlPathMap;
    }
}
