package ru.yandex.market.clickphite.dictionary.loaders;

import com.google.common.base.Preconditions;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.YtSource;

import java.net.URISyntaxException;

import static org.apache.http.HttpHeaders.AUTHORIZATION;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class YtDictionaryLoader extends HttpDictionaryLoader {

    private String ytProxy;
    private String ytToken;

    @Override
    public String getDownloadUrl(Dictionary dictionary) {
        try {
            return new URIBuilder("https://" + ytProxy + "/api/v3/read_table")
                .addParameter("path", getSourceYtPath(dictionary))
                .addParameter("output_format[$value]", "json")
                .addParameter("output_format[$attributes][encode_utf8]", "false")
                .addParameter("dump_error_into_response", "true")
                .build()
                .toString();
        } catch (URISyntaxException e) {
            throw new RuntimeException("Unable to build url", e);
        }
    }

    protected String getSourceYtPath(Dictionary dictionary) {
        YtSource ytSource = dictionary.getClass().getAnnotation(YtSource.class);
        Preconditions.checkNotNull(ytSource,
            "Dictionary %s must be annotated by %s", dictionary.getTable(), YtSource.class.getCanonicalName());
        Preconditions.checkState(ytSource.value().length() > 0, "Empty yt path in %s", dictionary.getTable());
        return ytSource.value();
    }

    @Override
    protected HttpGet createGetRequest(Dictionary dictionary) {
        HttpGet httpGet = super.createGetRequest(dictionary);
        httpGet.addHeader(AUTHORIZATION, "OAuth " + ytToken);
        return httpGet;
    }

    @Required
    public void setYtProxy(String ytProxy) {
        this.ytProxy = ytProxy;
    }

    @Required
    public void setYtToken(String ytToken) {
        this.ytToken = ytToken;
    }
}
