package ru.yandex.market.clickphite.dictionary.loaders.host2dc;

import com.google.common.base.MoreObjects;

import java.util.Objects;

public class DictionaryData {
    private String host;
    private String dc;
    private String stage;

    public DictionaryData(String host, String dc, String stage) {
        this.host = host;
        this.dc = MoreObjects.firstNonNull(dc, "");
        this.stage = MoreObjects.firstNonNull(stage, "");
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDc() {
        return dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DictionaryData data = (DictionaryData) o;
        return Objects.equals(host, data.host) &&
            Objects.equals(dc, data.dc) &&
            Objects.equals(stage, data.stage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, dc, stage);
    }
}
